<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\RestaurantController;
use App\Http\Controllers\Login_con;


Route::get('/', function () {
    return view('auth.login');
});


// Route::get('/create_account',[Login_con::class,'index'])->name('create_account');


// Route::post('/create',[Login_con::class,'create']);


Route::get('/login',[Login_con::class,'login'])->name('auth.login');

Route::get('/forgot_password',[Login_con::class,'forgot_password'])->name('forgot.password');

Route::post('/create_forgot_pass',[Login_con::class,'create_forgot_pass']);

Route::get('/partnerwithus',[Login_con::class,'patnerwithus'])->name('auth.patnerwithus');

Route::post('/create_patnerwithus',[Login_con::class,'create_patnerwithus']);

Route::post('/check',[Login_con::class,'check_user']);


Route::get('/welcome',[Login_con::class,'protect']);


Route::get('/logout',[Login_con::class,'logout'], function (){
    return view('auth.login');
})->name('logout-res');





//admin 
Route::group(['prefix' => 'admin'], function() {
    
    
    Route::get('/dashboard', function (){
        return view('admin.deshbord');
    })->name('admin.dashboard');


    Route::get('/restaurants', [AdminController::class,'RestaurantList'],function (){
        return view('admin.restaurants');
    })->name('admin.restaurants');
    Route::get('/restaurant/create', [AdminController::class,'createRestaurantList'], function (){
        return view('admin.create_restaurant');
    })->name('admin.restaurant.create');
    

    Route::get('/orders', function (){
        return view('admin.orders');
    })->name('admin.orders');


    Route::get('/order_details', function (){
        return view('admin.order_details');
    })->name('admin.order_details');
    

    Route::get('/dishes',[AdminController::class,'DishList'], function (){
        return view('admin.dishes');
    })->name('admin.dishes');
    Route::get('/dish/create',[AdminController::class,'createDishList'],function (){
        return view('admin.create_dish');
    })->name('admin.dish.create');


    Route::get('/dish_categories',[AdminController::class,'DishCategoryList'], function (){
        return view('admin.dish_categories');
    })->name('admin.dish_categories');
    Route::get('/dish_category/create', function (){
        return view('admin.create_dish_category');
    })->name('admin.dish_category.create');


    Route::get('/addons',[AdminController::class,'AddonList'], function (){
        return view('admin.addons');
    })->name('admin.addons');
    Route::get('/addon/create', [AdminController::class,'createAddonList'],function (){
        return view('admin.create_addon');
    })->name('admin.addons.create');
    

    Route::get('/addon/category',[AdminController::class,'AddonCategoryList'], function (){
        return view('admin.addons_category');
    })->name('admin.addoncategory');
    Route::get('/addon/category/create', function (){
        return view('admin.create_addon_category');
    })->name('admin.addon.category.create');
    
    
    Route::get('/coupons', [AdminController::class,'CouponList'],function (){
        return view('admin.manage_coupons');
    })->name('admin.coupons');
    Route::get('/coupons/create', [AdminController::class,'createCouponList'], function (){
        return view('admin.create_coupon');
    })->name('admin.coupon.create');


    Route::get('/setting', function (){
        return view('admin.restaurant');
    });
   
});




Route::group(['prefix' => 'users'], function() {
    
    Route::get('/customers',[AdminController::class,'Show_Wepppi'], function (){
        return view('admin.customers');
    })->name('admin.customers');

    Route::get('/owners', function (){
        return view('admin.owners');
    })->name('admin.owners');
    
});

Route::post('/admin/restaurant/create',[AdminController::class,'CreateRestaurant'])->name('save.restaurant');

Route::post('/admin/dish/create',[AdminController::class,'CreateDish'])->name('save.dish');

Route::post('/admin/dish/category/create',[AdminController::class,'CreateDishCategory'])->name('save.dishcategory');

Route::post('/admin/addon/create',[AdminController::class,'CreateAddon'])->name('save.addon');

Route::post('/admin/addon/category/create',[AdminController::class,'CreateAddonCategory'])->name('save.addoncategory');

Route::post('/admin/coupon/create',[AdminController::class,'CreateCoupon'])->name('save.coupon');

//edit Restaurant

Route::get('/admin/restaurant/edit/{id}',[AdminController::class,'EditRestaurant'])->name('edit.restaurant');
Route::post('/admin/restaurant/edit',[AdminController::class,'UpdateRestaurant'])->name('update.restaurant');
Route::get('/admin/restaurant/delete/{id}', [AdminController::class,'DeleteRestaurants'])->name('delete.restaurant');

//edit Dish

Route::get('/admin/dish/edit/{id}',[AdminController::class,'EditDish'])->name('edit.dish');
Route::post('/admin/dish/edit',[AdminController::class,'UpdateDish'])->name('update.dish');
Route::get('/admin/dish/delete/{id}', [AdminController::class,'DeleteDish'])->name('delete.dish');

//edit Dish category

Route::get('/admin/dish/category/edit/{id}',[AdminController::class,'EditDishCategory'])->name('edit.dishcategory');
Route::post('/admin/dish/category/edit',[AdminController::class,'UpdateDishCategory'])->name('update.dishcategory');
Route::get('/admin/dish/category/delete/{id}', [AdminController::class,'DeleteDishCategory'])->name('delete.dishcategory');

//edit addons

Route::get('/admin/addons/edit/{id}',[AdminController::class,'EditAddons'])->name('edit.addons');
Route::post('/admin/addons/edit',[AdminController::class,'UpdateAddons'])->name('update.addons');
Route::get('/admin/addons/delete/{id}', [AdminController::class,'DeleteAddons'])->name('delete.addons');

//edit addons category

Route::get('/admin/addon/category/edit/{id}',[AdminController::class,'EditAddonsCategory'])->name('edit.category');
Route::post('/admin/addon/category/edit',[AdminController::class,'UpdateCategory'])->name('update.category');
Route::get('/admin/addon/category/delete/{id}', [AdminController::class,'DeleteCategory'])->name('delete.category');

//edit coupons

Route::get('/admin/coupons/edit/{id}',[AdminController::class,'EditCoupons'])->name('edit.coupons');
Route::post('/admin/coupons/edit',[AdminController::class,'UpdateCoupons'])->name('update.coupons');
Route::get('/admin/coupons/delete/{id}', [AdminController::class,'DeleteCoupons'])->name('delete.coupons');


// restaurant-owner 

Route::group(['prefix' => 'restaurant-owner'], function() {
   
    Route::get('/dashboard',[RestaurantController::class,'DishListDash'], function (){
        return view('restaurant-owner.dashboard');
    })->name('restaurant-owner.dashboard');
    

    Route::get('/live-orders' ,[RestaurantController::class,'Show_live_Request'], function (){
        return view('restaurant-owner.live-orders');
    })->name('restaurant-owner.live-orders');


    Route::get('/orders',[RestaurantController::class,'Show_Follow_Ups'], function (){
        return view('restaurant-owner.orders');
    })->name('restaurant-owner.orders');

    
    Route::get('/order_details', function (){
        return view('restaurant-owner.order_details');
    })->name('restaurant-owner.order_details');


    Route::get('/dishes',[RestaurantController::class,'DishList'], function (){
        return view('restaurant-owner.dishes');
    })->name('restaurant-owner.dishes');
    Route::get('/dish/create',[RestaurantController::class,'createDishList'],function (){
        return view('restaurant-owner.create_dish');
    })->name('restaurant-owner.dish.create');


    Route::get('/dish_categories',[RestaurantController::class,'DishCategoryList'], function (){
        return view('restaurant-owner.dish_categories');
    })->name('restaurant-owner.dish_categories');
    Route::get('/dish_category/create', function (){
        return view('restaurant-owner.create_dish_category');
    })->name('restaurant-owner.dish_category.create');


    Route::get('/dish_addons', [RestaurantController::class,'AddonList'],function (){
        return view('restaurant-owner.dish_addons');
    })->name('restaurant-owner.dish_addons');
    Route::get('/dish_addons/create',[RestaurantController::class,'createAddonList'],function (){
        return view('restaurant-owner.create_addon');
    })->name('restaurant-owner.addons.create');


    Route::get('/dish_addons_categories',[RestaurantController::class,'AddonCategoryList'] ,function (){
        return view('restaurant-owner.dish_addons_categories');
    })->name('restaurant-owner.dish_addons_categories');
    Route::get('/dish_addons_categories/create',function (){
        return view('restaurant-owner.create_addon_category');
    })->name('restaurant-owner.addons_categories.create');


    Route::get('/coupons', [RestaurantController::class,'CouponList'],function (){
        return view('restaurant-owner.manage_coupons');
    })->name('restaurant-owner.coupons');
    Route::get('/coupons/create', [RestaurantController::class,'createCouponList'], function (){
        return view('restaurant-owner.create_coupon');
    })->name('restaurant-owner.coupon.create');
    
    
    // Route::get('/setting', [RestaurantController::class,'RestaurantList1'], function (){
    //     return view('restaurant-owner.profile');
    // })->name('restaurant-owner.profile');

    Route::get('/payment', function (){
        return view('restaurant-owner.payment');
    })->name('restaurant-owner.payment');

    Route::get('/review', function (){
        return view('restaurant-owner.review');
    })->name('restaurant-owner.review');

    Route::get('/location', function (){
        return view('restaurant-owner.location');
    })->name('restaurant-owner.location');
    Route::get('/location/create', function (){
        return view('restaurant-owner.create_location');
    })->name('restaurant-owner.location.create');

    Route::get('/help', function (){
        return view('restaurant-owner.help');
    })->name('restaurant-owner.help');
});

Route::post('/restaurant-owner/location/create',[RestaurantController::class,'CreateLocation'])->name('save.location');
Route::get('/restaurant-owner/location/edit/{id}',[RestaurantController::class,'EditLocation'])->name('edit.location');
Route::post('/restaurant-owner/location/edit',[RestaurantController::class,'UpdateLocation'])->name('update.location');
Route::get('/restaurant-owner/location/delete/{id}', [RestaurantController::class,'DeleteLocation'])->name('delete.location');
//
Route::post('/restaurant-owner/dish/create',[RestaurantController::class,'CreateDish'])->name('save.dish-res');
Route::post('/restaurant-owner/addon/create',[RestaurantController::class,'CreateAddon'])->name('save.addon-res');
Route::post('/restaurant-owner/dish_addons_categories/create',[RestaurantController::class,'CreateAddonCategory'])->name('save.addons_cat-res');
Route::post('/restaurant-owner/coupon/create',[RestaurantController::class,'CreateCoupon'])->name('save.coupon-res');


//edit Dish
Route::get('/restaurant-owner/dishes/edit/{id}',[RestaurantController::class,'EditDish'])->name('edit.dish-res');
Route::post('/restaurant-owner/dishes/edit',[RestaurantController::class,'UpdateDish'])->name('update.dish-res');
Route::get('/restaurant-owner/dishes/delete/{id}', [RestaurantController::class,'DeleteDish'])->name('delete.dish-res');


//edit Dish category
Route::post('/restaurant-owner/dish/category/create',[RestaurantController::class,'CreateDishCategory'])->name('save.dishcategory-res');
Route::get('/restaurant-owner/dish/category/edit/{id}',[RestaurantController::class,'EditDishCategory'])->name('edit.dishcategory-res');
Route::post('/restaurant-owner/dish/category/edit',[RestaurantController::class,'UpdateDishCategory'])->name('update.dishcategory-res');
Route::get('/restaurant-owner/dish/category/delete/{id}', [RestaurantController::class,'DeleteDishCategory'])->name('delete.dishcategory-res');
 

//edit addons
Route::get('/restaurant-owner/dish_addons/edit/{id}',[RestaurantController::class,'EditAddons'])->name('edit.addons-res');
Route::post('/restaurant-owner/dish_addons/edit',[RestaurantController::class,'UpdateAddons'])->name('update.addons-res');
Route::get('/restaurant-owner/dish_addons/delete/{id}', [RestaurantController::class,'DeleteAddons'])->name('delete.addons-res');


//edit addons category
Route::get('/restaurant-owner/addon/category/edit/{id}',[RestaurantController::class,'EditAddonsCategory'])->name('edit.category-res');
Route::post('/restaurant-owner/addon/category/edit',[RestaurantController::class,'UpdateCategory'])->name('update.category-res');
Route::get('/restaurant-owner/addon/category/delete/{id}', [RestaurantController::class,'DeleteCategory'])->name('delete.category-res');


//edit coupons

Route::get('/restaurant-owner/coupons/edit/{id}',[RestaurantController::class,'EditCoupons'])->name('edit.coupons-res');
Route::post('/restaurant-owner/coupons/edit',[RestaurantController::class,'UpdateCoupons'])->name('update.coupons-res');
Route::get('/restaurant-owner/coupons/delete/{id}', [RestaurantController::class,'DeleteCoupons'])->name('delete.coupons-res');

//setting


Route::get('/restaurant-owner/setting',[RestaurantController::class,'EditProfile'])->name('edit.profile');
Route::post('/restaurant-owner/setting/edit',[RestaurantController::class,'UpdateRestaurant'])->name('update.restaurant-res');

//login

Route::get('/restaurant-owner/login', function (){
    return view('restaurant-owner.login');
})->name('admin.login');


Route::post('/live-request-store',[RestaurantController::class,'Live_Request_Store'])->name('live-request-store');




