<?php

namespace App\Http\Controllers;
use DB;
use Illuminate\Http\Request;
//use Illuminate\Support\Facades\Storage;
use App\Models\dish_categories;
use App\Models\restaurants;
use App\Models\dishes;
use Session;
use Illuminate\Support\Facades\File;

class RestaurantController extends Controller
{
    //dish
    public function CreateDish(Request $request)
    {
        $imgname="";
        if($request->hasFile('image')){   
        $imgname = $request->image->getClientOriginalName();
        $request->image->storeAs('',$imgname,'public');
        }
        DB::table('dishes')->insert([
            'name'=>$request->name,
            'description'=>$request->description,
            'image'=>$imgname,
            'price'=>$request->price,
            'discount_price'=>$request->discount_price,
            'calories'=>$request->calories,
            'protien'=>$request->protien,
            'sodium'=>$request->sodium,
            'cholesterol'=>$request->cholesterol,
            'is_veg'=>$request->is_veg,
            'glu_free'=>$request->glu_free, 
            'active'=>$request->active, 
            'restaurant_id'=>$request->restaurant_id,
            'dish_category_id'=>$request->dish_category_id,
            'addons_category_id'=>$request->addons_category_id,
        ]);
        return redirect('restaurant-owner/dishes')->with('Restaurant_create','Inserted Successfully');
    }
    public function DishList()
    {
        $dishes = DB::table('dishes')->get();
        return view('restaurant-owner/dishes',compact('dishes'));
    }
    public function DishListDash()
    {
        $dishes = DB::table('dishes')->get();
        return view('restaurant-owner.dashboard',compact('dishes'));
    }
    public function EditDish($id)
    {
        $dishes = DB::table('dishes')->where('id',$id)->first();
        $restaurants = DB::table('restaurants')->get();
        $addonscategories = DB::table('addons_categories')->get();
        $dish_categories = DB::table('dish_categories')->get();
        return view('restaurant-owner/edit_dish',compact('dishes','restaurants','addonscategories','dish_categories'));
    }
    public function UpdateDish(Request $request)
    {
        $dishes = dishes::find($request->id);

        if($request->image != null)
        {
         
            File :: delete (public_path ('/upload/'.$dishes->image));
            $imgname = $request->image->getClientOriginalName();
            $request->image->storeAs('',$imgname,'public');
        }
        else
        {
            $imgname=$dishes->image;
        }
        $dishes = DB::table('dishes')->where('id',$request->id)->update([ 
            'name'=>$request->name,
            'description'=>$request->description,
            'image'=>$imgname,
            'price'=>$request->price,
            'discount_price'=>$request->discount_price,
            'calories'=>$request->calories,
            'protien'=>$request->protien,
            'sodium'=>$request->sodium,
            'cholesterol'=>$request->cholesterol,
            'is_veg'=>$request->is_veg,
            'glu_free'=>$request->glu_free, 
            'active'=>$request->active, 
            'restaurant_id'=>$request->restaurant_id,
            'dish_category_id'=>$request->dish_category_id,
            'addons_category_id'=>$request->addons_category_id,
        ]);
        return redirect('/restaurant-owner/dishes')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteDish($id)
    {
        $dishes = dishes::find($id);
      
        File :: delete (public_path ('/upload/'.$dishes->image));
        $dishes = DB::table('dishes')->where('id',$id)->delete();
        return redirect('/restaurant-owner/dishes')->with('dishes_delete','Dishes Delete Successfully');
    } 
    //create_dish display lists
    public function createDishList()
    {   
        $restaurants = DB::table('restaurants')->get();
        $addonscategories = DB::table('addons_categories')->get();
        $dish_categories = DB::table('dish_categories')->get();
        return view('restaurant-owner/create_dish',compact('restaurants','addonscategories','dish_categories'));
    }

    
    //Dish category
    public function CreateDishCategory(Request $request){
        $imgname="";
        if($request->hasFile('image')){   
        $imgname = $request->image->getClientOriginalName();
        $request->image->storeAs('',$imgname,'public');
        }
        DB::table('dish_categories')->insert([
            'name'=>$request->name,
            'active'=>$request->active,
            'image'=>$imgname,
        ]);
        return redirect('/restaurant-owner/dish_categories')->with('Restaurant_create','Inserted Successfully');
    }
    public function DishCategoryList(){
        $dish_categories = DB::table('dish_categories')->get();
        return view('restaurant-owner/dish_categories',compact('dish_categories'));
    }
    public function EditDishCategory($id)
    {
        $dish_categories = DB::table('dish_categories')->where('id',$id)->first();
        return view('restaurant-owner/edit_dish_category',compact('dish_categories'));
    }
    public function UpdateDishCategory(Request $request){
        // unlink(public_path('images').'/'.$dish_categories->image);
        $dish_categories = dish_categories::find($request->id);

        if($request->image != null)
        {
            
            File :: delete (public_path ('/upload/'.$dish_categories->image));
            $imgname = $request->image->getClientOriginalName();
            $request->image->storeAs('',$imgname,'public');
        }
        else
        {
            $imgname=$dish_categories->image;
        }
        $dish_categories = DB::table('dish_categories')->where('id',$request->id)->update([ 
            'name'=>$request->name,
            'active'=>$request->active,
            'image'=>$imgname,
        ]);
        return redirect('/restaurant-owner/dish_categories')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteDishCategory($id)
    {        
        $dish_categories = dish_categories::find($id);
       
        File :: delete (public_path ('/upload/'.$dish_categories->image));
        $dish_categories = DB::table('dish_categories')->where('id',$id)->delete();
        return redirect('/restaurant-owner/dish_categories')->with('dishes_delete','Dishes Delete Successfully');
    }


    //Addon
    public function CreateAddon(Request $request){
        DB::table('addons')->insert([
            'name'=>$request->name,
            'addons_category_id'=>$request->addons_category_id,
            'price'=>$request->price,
            'active'=>$request->active,    
        ]);
        return redirect('/restaurant-owner/dish_addons')->with('Restaurant_create','Inserted Successfully');
    }
    public function AddonList(){
        $addons = DB::table('addons')->get();
        return view('restaurant-owner/dish_addons',compact('addons'));
    }
    public function EditAddons($id)
    {
        $addons = DB::table('addons')->where('id',$id)->first();
        $addons_categories = DB::table('addons_categories')->get();
        return view('restaurant-owner/edit_addon',compact('addons','addons_categories'));
    }
    public function UpdateAddons(Request $request)
    {
        $addons = DB::table('addons')->where('id',$request->id)->update([
            'name'=>$request->name,
            'addons_category_id'=>$request->addons_category_id,
            'price'=>$request->price,
            'active'=>$request->active, 
        ]);
        return redirect('/restaurant-owner/dish_addons')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteAddons($id)
    { 
        $addons = DB::table('addons')->where('id',$id)->delete();
        return redirect('/restaurant-owner/dish_addons')->with('dishes_delete','Dishes Delete Successfully');
    }    
    //create_Addon display lists
    public function createAddonList()
    {   
        $addons_categories = DB::table('addons_categories')->get();
        return view('restaurant-owner/create_addon',compact('addons_categories'));
    }

    
    //Addon category
    public function CreateAddonCategory(Request $request){
        DB::table('addons_categories')->insert([
            'name'=>$request->name,
            'type'=>$request->type, 
        ]);
        return redirect('restaurant-owner/dish_addons_categories')->with('Restaurant_create','Inserted Successfully');
    }
    public function AddonCategoryList(){
        $addonscategories = DB::table('addons_categories')->get();
        return view('restaurant-owner/dish_addons_categories',compact('addonscategories'));
    }
    public function EditAddonsCategory($id)
    {
        $addons_categories = DB::table('addons_categories')->where('id',$id)->first();
        return view('restaurant-owner/edit_addon_category',compact('addons_categories'));
    }
    public function UpdateCategory(Request $request)
    {
        $addons_categories = DB::table('addons_categories')->where('id',$request->id)->update([
            'name'=>$request->name,
            'type'=>$request->type,  
        ]);
        return redirect('/restaurant-owner/dish_addons_categories')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteCategory($id)
    { 
        $addons_categories = DB::table('addons_categories')->where('id',$id)->delete();
        return redirect('/restaurant-owner/dish_addons_categories')->with('dishes_delete','Dishes Delete Successfully');
    }
    //coupons 
    public function CreateCoupon(Request $request){
        
        DB::table('coupons')->insert([
            'name'=>$request->name,
            'description'=>$request->description,
            'coupon_code'=>$request->coupon_code,
            'discount_type'=>$request->discount_type,
            'discount'=>$request->discount,
            'expiry_date'=>$request->expiry_date,
            'max_usage'=>$request->max_usage,
            'active'=>$request->active,
            'restaurant_id'=>$request->restaurant_id,  
        ]);
        return redirect('/restaurant-owner/coupons')->with('Restaurant_create','Inserted Successfully');
    }
    public function CouponList()
    { 
        // $coupons = DB::table('coupons')->get();
        $coupons = DB::table('coupons')->join('restaurants','restaurants.id','=','coupons.restaurant_id')
        ->select('restaurants.name as rname','coupons.*')->get();

        return view('restaurant-owner/manage_coupons',compact('coupons'));
    }
    public function EditCoupons($id)
    {
        $coupons = DB::table('coupons')->where('id',$id)->first();
        $restaurants = DB::table('restaurants')->get();
        return view('restaurant-owner/edit_coupon',compact('coupons','restaurants'));
    }
    public function UpdateCoupons(Request $request)
    {
       
        $coupons = DB::table('coupons')->where('id',$request->id)->update([
            'name'=>$request->name,
                'description'=>$request->description,
                'coupon_code'=>$request->coupon_code,
                'discount_type'=>$request->discount_type,
                'discount'=>$request->discount,
                'expiry_date'=>$request->expiry_date,
                'max_usage'=>$request->max_usage,
                'active'=>$request->active,
                'restaurant_id'=>$request->restaurant_id,
        ]);
        return redirect('/restaurant-owner/coupons')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteCoupons($id)
    {  
        $coupons = DB::table('coupons')->where('id',$id)->delete();
        return redirect('/restaurant-owner/coupons')->with('dishes_delete','Dishes Delete Successfully');
    }
    //create_coupon display lists
    public function createCouponList()
    {   
        $restaurants = DB::table('restaurants')->get();
        return view('restaurant-owner/create_coupon',compact('restaurants'));
    }
    //edit setting

    public function EditRestaurant($id)
    {
        $restaurants = DB::table('restaurants')->where('id',$id)->first();
        $foodtypes = DB::table('foodtypes')->get();
        return view('admin/edit_restaurant',compact('restaurants','foodtypes'));
    }
    public function UpdateRestaurant(Request $request)
    {
    	

        $restaurants = restaurants::find($request->id);

        if($request->image != null)
        {
            session()->forget('reslogo');
            File :: delete (public_path ('/upload/'.$restaurants->image));
            $imgname = $request->image->getClientOriginalName();
            session()->put('reslogo',$imgname);
           $request->image->storeAs('',$imgname,'public');
        
         
        }
        else
        {
            session()->forget('reslogo');
            $imgname=$restaurants->image;
            session()->put('reslogo',$imgname);
           
        }
        $restaurants = DB::table('restaurants')->where('id',$request->id)->update([
            'image'=>$imgname,
            'name'=>$request->name,
            'description'=>$request->description,
            'foodtype_id'=>$request->foodtype_id,
            'user_id'=>$request->user_id,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'rating'=>$request->rating,
            'delivery_time'=>$request->delivery_time,
            'delivery_radius'=>$request->delivery_radius,
            'for_two'=>$request->for_two,
            'mon'=>$request->mon,
            'mon_opentime' =>$request->mon_opentime,
            'tue_opentime' =>$request->tue_opentime,
            'wed_opentime' =>$request->wed_opentime,
            'thu_opentime' =>$request->thu_opentime,
            'fri_opentime' =>$request->fri_opentime,
            'sat_opentime' =>$request->sat_opentime,
            'sun_opentime' =>$request->sun_opentime,
            'mon_closetime' =>$request->mon_closetime,
            'tue_closetime' =>$request->tue_closetime,
            'thu_closetime' =>$request->thu_closetime,
            'wed_closetime' =>$request->wed_closetime,
            'fri_closetime' =>$request->fri_closetime,
            'sat_closetime' =>$request->sat_closetime,
            'sun_closetime' =>$request->sun_closetime,
            'tue'=>$request->tue,
            'wed'=>$request->wed,
            'thu'=>$request->thu,
            'fri'=>$request->fri,
            'sat'=>$request->sat,
            'sun'=>$request->sun,
            'is_veg'=>$request->is_veg,
            'active'=>$request->active,
        ]);
        $restaurant_addresses = DB::table('restaurant_addresses')->where('restaurant_id',$request->id)->update([
            'address'=>$request->address,
            'pincode'=>$request->pincode,
            'city'=>$request->city,
            'lat'=>$request->lat,
            'long'=>$request->long,
          
        ]);

        session()->forget('resname');
        session()->put('resname',$request->name);
      
        return redirect('/restaurant-owner/dashboard')->with('Restaurant_edit','Edited Successfully');
    }




// location 
    public function CreateLocation(Request $request)
    {
        
        // $restaurants = DB::table('restaurants')->latest('id')->first();
        // $lastid=$restaurants->id;
        
        DB::table('restaurant_addresses')->insert([ 
            'address'=>$request->address,
            // 'name'=>$request->name,
            'pincode'=>$request->pincode,
            'city'=>$request->city,
            'lat'=>$request->lat,
            'long'=>$request->long,
            // 'restaurant_id'=>$lastid,
            'opentime'=>$request->opentime,
            'closetime'=>$request->closetime,
        ]);
        return redirect('/admin/restaurants')->with('Restaurant_create','Inserted Successfully');
    }
    public function RestaurantList()
    {
        $restaurants = DB::table('restaurants')->get();
        return view('admin/restaurants',compact('restaurants'));
    }
    public function EditLocation($id)
    {
        $restaurants = DB::table('restaurants')->where('id',$id)->first();
        $foodtypes = DB::table('foodtypes')->get();
        return view('admin/edit_restaurant',compact('restaurants','foodtypes'));
    }
    public function UpdateLocation(Request $request)
    {
        $restaurants = restaurants::find($request->id);

        if($request->image != null)
        {
           
            File :: delete (public_path ('/upload/'.$restaurants->image));
            $imgname = $request->image->getClientOriginalName();
            $request->image->storeAs('',$imgname,'public');
        }
        else
        {
            $imgname=$restaurants->image;
        }
        $restaurants = DB::table('restaurants')->where('id',$request->id)->update([
            'image'=>$imgname,
            'name'=>$request->name,
            'description'=>$request->description,
            'foodtype_id'=>$request->foodtype_id,
            // 'user_id'=>$request->user_id,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'rating'=>$request->rating,
            'delivery_time'=>$request->delivery_time,
            'delivery_radius'=>$request->delivery_radius,
            'for_two'=>$request->for_two,
            'opentime'=>$request->opentime,
            'closetime'=>$request->closetime,
            // 'commission_rate'=>$request->commission_rate,
            // 'license_code'=>$request->license_code,
            // 'restaurant_charges'=>$request->restaurant_charges,
            'is_veg'=>$request->is_veg,
            // 'featured'=>$request->featured,
            'active'=>$request->active,
            
        ]);
        $restaurant_addresses = DB::table('restaurant_addresses')->where('restaurant_id',$request->id)->update([
            'address'=>$request->address,
            'pincode'=>$request->pincode,
            'city'=>$request->city,
            'lat'=>$request->lat,
            'long'=>$request->long,
        ]);
        
        return redirect('/restaurant-owner/restaurants')->with('Restaurant_edit','Edited Successfully');
    }
    public function DeleteLocation($id)
    {   
        $restaurants = restaurants::find($id);
       
        File :: delete (public_path ('/upload/'.$restaurants->image));
        $restaurants = DB::table('restaurants')->where('id',$id)->delete();
        $restaurant_addresses = DB::table('restaurant_addresses')->where('restaurant_id',$id)->delete();
        return redirect('/admin/restaurants')->with('restaurant_delete','Post Delete Successfully');
    }
    public function RestaurantList1()
    {
        $restaurants1 = DB::table('restaurants')->where('id','2')->get();
        print_r($restaurants1);
        return view('restaurant-owner.profile',compact('restaurants1'));
    }
    public function EditProfile()
    {
        $id = Session::get('owner_id');
        $restaurants = DB::table('restaurants')->where('user_id',$id)->first();
        $resid = $restaurants->id;
        $restaurant_addresses = DB::table('restaurant_addresses')->where('restaurant_id',$resid)->first();
        $foodtypes = DB::table('foodtypes')->get();
        $users = DB::table('users')->get();
        return view('restaurant-owner.profile',compact('restaurants','foodtypes','restaurant_addresses','users'));
    }
}
