<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\VerificationController;
use App\Http\Controllers\Api\FindRestaurantController;
use App\Http\Controllers\Api\FindWepppiController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\BlockController;
use App\Http\Controllers\Api\RatingController;
use App\Http\Controllers\Api\ReviewController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
Route::group([
    'middleware' => 'api',
], function ($router) {
    Route::post('/signup', [VerificationController::class, 'SignUp']);
    Route::post('/login', [VerificationController::class, 'LogIn']);
    Route::post('/find_restaurant_name', [FindRestaurantController::class, 'FindRestaurant_name']);
    Route::post('/find_restaurant_location', [FindRestaurantController::class, 'FindRestaurant_location']);
    Route::post('/find_restaurant_cuisine', [FindRestaurantController::class, 'FindRestaurant_cuisine']);
    Route::post('/find_dish', [FindRestaurantController::class, 'Find_dish']);
    Route::post('/find_wepppi_name', [FindWepppiController::class, 'Find_Wepppi_name']);
    Route::post('/find_wepppi_location', [FindWepppiController::class, 'Find_wepppi_location']);
    Route::get('/show_cuisine', [FindWepppiController::class, 'show_cuisine']);
    Route::post('/find_wepppi_cuisine', [FindWepppiController::class, 'Find_wepppi_cuisine']);
    Route::get('/find_top_five', [RatingController::class, 'top_5_restaurant']);
    Route::post('/proflie', [ProfileController::class, 'Profile']);
    Route::put('/proflie/{id}', [ProfileController::class, 'EditProfile']);
    Route::post('/notification', [NotificationController::class, 'Comment']);
    Route::post('/block', [BlockController::class, 'Block']);
    Route::put('/unblock', [BlockController::class, 'UnBlock']);
    Route::post('/review', [ReviewController::class, 'Review']);
    Route::post('/review_list', [ReviewController::class, 'Review_list']);
    Route::put('/edit_review/{id}', [ReviewController::class, 'Edit_Review']);
    Route::delete('/delete_review/{id}', [ReviewController::class, 'Delete_Review']);
    
    
   
    
});